import pygame
import random
import math

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 11 - flag waving"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.lighting = False
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    #instance variables to be replaced with objects
    self.points = [] #x by y grid of points
    self.rot = [0,0,0]
  def initGL(self):
    if not self.texloaded: self.loadGLTextures()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambientlight)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuselight)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lightpos)
    glEnable(GL_LIGHT1)
    glPolygonMode(GL_BACK,GL_FILL)#fill in back
    glPolygonMode(GL_FRONT,GL_LINE)#just wireframe in front
    #initialize points
    for x in range(45):
      col = []
      for y in range(45):
        px = x/5.-4.5
        py = y/5.-4.5
        pz = math.sin(x/5.*40./360.*math.pi*2)
        col.append([px,py,pz])
      self.points.append(col)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Tim.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(2)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #linear filter
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,-12)
    glRotatef(self.rot[0],1,0,0)
    glRotatef(self.rot[1],0,1,0)
    glRotatef(self.rot[2],0,0,2)
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    
    #draw initial
    glBegin(GL_QUADS)
    for x in range(len(self.points)-1):
      col = self.points[x]
      for y in range(len(col)-1):
        p = self.points[x][y]
        pr = self.points[x+1][y]
        pu = self.points[x][y+1]
        pru = self.points[x+1][y+1]
        xa,ya = (x/44.,y/44.)
        xb,yb = (x+1)/44.,(y+1)/44.
        #drawing in clockwise order, faces will be back faces
        glTexCoord2f(xa,ya); glVertex3f(p[0],p[1],p[2])
        glTexCoord2f(xa,yb); glVertex3f(pu[0],pu[1],pu[2])
        glTexCoord2f(xb,yb); glVertex3f(pru[0],pru[1],pru[2])
        glTexCoord2f(xb,ya); glVertex3f(pr[0],pr[1],pr[2])
    glEnd()
    #move each points z to next points z
    for y in range(len(self.points[0])):
      leftpoint = self.points[0][y]
      for x in range(len(self.points)-1):
        self.points[x][y][2] = self.points[x+1][y][2]
      self.points[44][y][2] = leftpoint[2]
    #rotate
    self.rot[0] += .3
    self.rot[1] += .2
    self.rot[2] += .4

screen = Screen()
screen.resize()

piover180 = math.pi/180.0
running = 1
c = pygame.time.Clock()
while running:
  c.tick(60)
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
      if e.key==pygame.K_l:
        screen.lighting = not screen.lighting
        if screen.lighting:
          glEnable(GL_LIGHTING)
        else:
          glDisable(GL_LIGHTING)
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    pass
  if keys[pygame.K_PAGEDOWN]:
    pass
  if keys[pygame.K_RIGHT]:
    pass
  if keys[pygame.K_LEFT]:
    pass
  if keys[pygame.K_UP]:
    pass
  if keys[pygame.K_DOWN]:
    pass
